# Antigravityへの指示プロンプト集

このAI指令室システムを、あなたの環境に合わせてカスタマイズしたり、新しい機能を追加したりするための「魔法の言葉（プロンプト）」を集めました。
ChatGPTやGeminiなどのAIに、以下の文章をそのまま貼り付けて相談してみてください。

## 1. 最初に設定で迷った時

```
私はMacを使っていて、Obsidianの保存場所がわかりません。
ターミナルを使って、自分のObsidianのVault（保管庫）のパスを調べるコマンドを教えてください。
```

## 2. 新しいスキル（機能）を追加したい時

### ケースA: 天気予報を知りたい
```
今ある `ai_monitor.py` に新しい機能を追加したいです。
「指示：天気予報」とObsidianに書くと、気象庁のサイトから東京の明日の天気を取得して、ノートにまとめてくれるPythonスクリプト `ai_weather.py` を作ってください。
また、それを `ai_monitor.py` から呼び出すための設定変更点も教えてください。
```

### ケースB: 画像をリサイズしたい
```
「指示：画像リサイズ」と書くと、デスクトップにある `input.jpg` という画像を読み込んで、横幅1000pxにリサイズして `output.jpg` として保存するPythonスクリプトを作ってください。
Pillowライブラリを使ってください。
```

### ケースC: LPの構成を考えたい
```
私はソロプレナー（個人起業家）です。
「LP作成」の指示を受けた時に、私のObsidianにある過去のメモ（一次情報）を元に、高成約率なLP構成案を作成するプロンプトを Ann（Antigravity）に伝えてください。
```

## 3. エラーが出た時

```
`Start_AI.command` を実行したら、以下のようなエラーが出ました。
（ここにエラーメッセージを貼り付ける）

どうすれば直りますか？初心者にもわかるように手順を教えてください。
```

---
Produced by Antigravity & Osamu Kasamatsu
