import os

# ==========================================
# AIコマンドセンター 設定ファイル
# ==========================================

# あなたのMacのユーザー名（ホームフォルダ名）を設定してください
# 例: "taro" ("yamada" ではありません)
# わからない場合は、ターミナルで `whoami` と入力して確認してください
USER_NAME = "YOUR_USERNAME_HERE"

# Obsidianのノートなどの保存場所（ホームフォルダからの相対パス）
# 一般的には "Documents/Obsidian Vault/My Notebook" のようになります
# ※ 先頭に "/" は付けないでください
OBSIDIAN_VAULT_RELATIVE_PATH = "Documents/Obsidian Vault"

# 監視対象のファイル名（このファイルに指示を書きます）
WATCH_FILE_NAME = "AI Task Dispatcher.md"

# OpenAI APIキー（ブログ記事生成に使用します）
# https://platform.openai.com/api-keys から取得してください
OPENAI_API_KEY = "sk-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

# ==========================================
# 以下は変更不要です（自動計算されます）
# ==========================================
HOME_DIR = f"/Users/{USER_NAME}"
OBSIDIAN_VAULT_PATH = os.path.join(HOME_DIR, OBSIDIAN_VAULT_RELATIVE_PATH)
WATCH_FILE_PATH = os.path.join(OBSIDIAN_VAULT_PATH, WATCH_FILE_NAME)
SCRIPTS_DIR = os.path.dirname(os.path.abspath(__file__))
