import feedparser
import datetime
import os
import sys
import settings # 設定ファイルを読み込む

# 設定
RSS_URL = "https://news.google.com/rss/search?q=AI&hl=ja&gl=JP&ceid=JP:ja"
VAULT_PATH = settings.OBSIDIAN_VAULT_PATH

def fetch_and_save_news():
    print("ニュースを取得中...")
    feed = feedparser.parse(RSS_URL)
    
    today = datetime.datetime.now().strftime("%Y-%m-%d")
    filename = f"AI News {today}.md"
    filepath = os.path.join(VAULT_PATH, filename)

    content = f"# AIニュース {today}\n\n"
    
    for i, entry in enumerate(feed.entries[:5]): # Top 5
        title = entry.title
        link = entry.link
        published = entry.published
        content += f"## {i+1}. {title}\n"
        content += f"- **日時**: {published}\n"
        content += f"- [記事を読む]({link})\n\n"

    content += "---\n*Auto-generated by AI Command Center*"

    try:
        with open(filepath, "w", encoding="utf-8") as f:
            f.write(content)
        print(f"ニュースを保存しました: {filepath}")
    except Exception as e:
        print(f"保存エラー: {e}")
        sys.exit(1)

if __name__ == "__main__":
    fetch_and_save_news()
