#!/bin/bash

# スクリプトのあるディレクトリに移動
cd "$(dirname "$0")/scripts"

# Pythonがインストールされているか確認
if ! command -v python3 &> /dev/null; then
    echo "エラー: Python 3 が見つかりません。"
    echo "Python 3 をインストールしてから再試行してください。"
    read -p "何かキーを押すと終了します..."
    exit 1
fi

# 必要なライブラリのインストール確認（簡易版）
pip3 show feedparser > /dev/null 2>&1
if [ $? -ne 0 ]; then
    echo "必要なライブラリ (feedparser) をインストールします..."
    pip3 install feedparser
fi

# モニターを開始
echo "AIコマンドセンターを起動します..."
python3 ai_monitor.py
